% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_tool.R
\name{diagnostic_tool}
\alias{diagnostic_tool}
\title{Diagnostic tool to identify the key components that best explain the MUMARINEX sub-indices}
\usage{
diagnostic_tool(x, g, ref, signif_test = TRUE, mute = FALSE)
}
\arguments{
\item{x}{A data frame or a matrix organized with samples in rows and species in columns.}

\item{g}{A vector of length \code{nrow(x)} indicating how the samples should be grouped (e.g., stations, treatments).}

\item{ref}{A logical or numeric vector identifying the reference row positions.}

\item{signif_test}{Logical; if TRUE, only sub-indices significantly lower than the reference conditions (t-test, p < 0.05) are returned. Conditions that are not statistically significant are indicated by 'ns'.}

\item{mute}{A logical indicating whether the results are displayed in the console.}
}
\value{
A data frame summarizing the key information explaining variations in CSR, CBCD, and CPI.
}
\description{
Identifies, for each sub-index, the species or taxa that contribute most to its variation.
}
\details{
diagnostic_tool
}
\note{
To reduce the risk of misleading interpretations, a one-sided significance test (t-test) is applied to sub-indices against the reference condition. Nevertheless, taxa identified as contributing to sub-index and MUMARINEX variations may not always be ecologically relevant, and the results are provided without any guarantee. This tool is not a substitute for a thorough ecological knowledge of the studied site and careful examination of the data, although it may help guide users toward potential hypotheses. The significance tests can be disabled, but the resulting outputs should then be interpreted with extreme caution.
}
\examples{
data("Simulated_data")
ref_idx<-41:50
stations<-matrix(unlist(strsplit(rownames(Simulated_data),".",fixed=TRUE)),ncol=2,byrow=TRUE)[,1]
diagnostic_tool(x=Simulated_data,g=stations,ref=ref_idx)
}
\seealso{
\code{\link[=decomplot]{decomplot()}}
}
