% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmvmr_main.R
\name{fmvmr_separate_twosample}
\alias{fmvmr_separate_twosample}
\title{Two-Sample Separate Univariable Functional MR}
\usage{
fmvmr_separate_twosample(
  G1_exposure,
  G2_exposure = NULL,
  fpca_results,
  by_outcome1,
  by_outcome2 = NULL,
  sy_outcome1,
  sy_outcome2 = NULL,
  ny_outcome,
  max_nPC1 = NA,
  max_nPC2 = NA,
  true_effects = NULL,
  verbose = TRUE
)
}
\arguments{
\item{G1_exposure}{Genetic instrument matrix from exposure 1 (N × J1)}

\item{G2_exposure}{Genetic instrument matrix from exposure 2 (N × J2) or NULL for single exposure}

\item{fpca_results}{List of 2 FPCA objects}

\item{by_outcome1}{SNP-outcome betas for exposure 1 instruments}

\item{by_outcome2}{SNP-outcome betas for exposure 2 instruments or NULL}

\item{sy_outcome1}{Standard errors for exposure 1}

\item{sy_outcome2}{Standard errors for exposure 2 or NULL}

\item{ny_outcome}{Outcome GWAS sample size}

\item{max_nPC1}{Maximum number of principal components to retain for exposure 1 (NA = automatically determined)}

\item{max_nPC2}{Maximum number of principal components to retain for exposure 2 (NA = automatically determined)}

\item{true_effects}{List containing true effects for exposure 1 and exposure 2 (simulation only)}

\item{verbose}{Print progress messages and diagnostics during computation}
}
\value{
fmvmr_separate_twosample object
}
\description{
Separate estimation for each exposure using outcome GWAS summary statistics.
For single exposure: set G2 = NULL, by2 = NULL, sy2 = NULL.
}
