% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marg.plot.R
\name{marg.plot}
\alias{marg.plot}
\title{Marginal density plots function}
\usage{
marg.plot(data.mat, title = NULL)
}
\arguments{
\item{data.mat}{data matrix including all the variables.}

\item{title}{title of each generated plot.}
}
\value{
Marginal density plot for each variable in the dataset.
}
\description{
Draws marginal density plots for all variables
}
\examples{
### generate some data
dat <- MASS::mvrnorm(n = 1000, mu = c(1, 2, 3, 4), Sigma = diag(4))

### set column names
colnames(dat) <- paste0("Var ", 1:ncol(dat))

### marginal plots
marg.plot(data.mat = dat, title = paste0("Var", 1:nrow(dat)))
}
