% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nLTTDiff.R
\name{nltt_diff_exact_brts}
\alias{nltt_diff_exact_brts}
\title{Calculates the exact difference between the nLTT
curves of the branching times}
\usage{
nltt_diff_exact_brts(
  b_times,
  lineages,
  b_times2,
  lineages2,
  distance_method = "abs",
  time_unit = "since"
)
}
\arguments{
\item{b_times}{branching times of the first phylogeny,}

\item{lineages}{the number of lineages,
usually one to the number of lineages}

\item{b_times2}{branching times of the first phylogeny}

\item{lineages2}{the number of lineages,
usually one to the number of lineages}

\item{distance_method}{how the difference between the two nLTTs is summed
\itemize{
 \item "abs: " the absolute distance between the two nLTTs is summed
 \item "squ: " the squared distance between the two nLTTs is summed
}}

\item{time_unit}{the time unit of the branching times
\itemize{
 \item "ago: " the branching times are postive,
   as these are in time units ago
 \item "since: " the branching times are negative,
   as these are in time units since present
}}
}
\description{
Calculates the exact difference between the nLTT
curves of the branching times
}
\author{
Thijs Janzen and Richèl Bilderbeek
}
