% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_learners.R
\name{lnr_nnet}
\alias{lnr_nnet}
\title{Use nnet for Binary Classification}
\usage{
lnr_nnet(data, formula, trace = FALSE, size, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{trace}{Whether nnet should print out its optimization success}

\item{size}{Size for neural network hidden layer}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of values, one for each row
of \code{newdata}).
}
\description{
Use nnet for Binary Classification
}
\examples{

lnr_nnet(mtcars, am ~ ., size = 50)(mtcars)
lnr_nnet(iris, I(Species=='setosa') ~ ., size = 50)(iris)

}
