% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness.R
\name{brightness_timeseries_folder}
\alias{brightness_timeseries_folder}
\title{Brightness time-series calculations for every image in a folder.}
\usage{
brightness_timeseries_folder(
  folder_path = ".",
  def,
  frames_per_set,
  overlap = FALSE,
  thresh = NULL,
  detrend = FALSE,
  quick = FALSE,
  filt = NULL,
  s = 1,
  offset = 0,
  readout_noise = 0,
  parallel = FALSE
)
}
\arguments{
\item{folder_path}{The path (relative or absolute) to the folder you wish to
process.}

\item{def}{A character. Which definition of brightness do you want to use,
\code{"B"} or \code{"epsilon"}?}

\item{frames_per_set}{The number of frames with which to calculate the
successive brightnesses.}

\item{overlap}{A boolean. If \code{TRUE}, the windows used to calculate number are
overlapped, if \code{FALSE}, they are not. For example, for a 20-frame image
series with 5 frames per set, if the windows are not overlapped, then the
frame sets used are 1-5, 6-10, 11-15 and 16-20; whereas if they are
overlapped, the frame sets are 1-5, 2-6, 3-7, 4-8 and so on up to 16-20.}

\item{thresh}{The threshold or thresholding method (see
\code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}}) to use on the image prior to
detrending and brightness calculations.}

\item{detrend}{Detrend your data with \code{\link[detrendr:detrending]{detrendr::img_detrend_rh()}}. This is
the best known detrending method for brightness analysis. For more
fine-grained control over your detrending, use the \code{detrendr} package. If
there are many channels, this may be specified as a vector, one element for
each channel.}

\item{quick}{If \code{FALSE} (the default), the swap finding routine is run
several times to get a consensus for the best parameter. If \code{TRUE}, the
swap finding routine is run only once.}

\item{filt}{Do you want to smooth (\code{filt = 'mean'}) or median (\code{filt = 'median'}) filter the number image using \code{\link[=smooth_filter]{smooth_filter()}} or
\code{\link[=median_filter]{median_filter()}} respectively? If selected, these are invoked here with a
filter radius of 1 (with corners included, so each median is the median of
9 elements) and with the option \code{na_count = TRUE}. If you want to
smooth/median filter the number image in a different way, first calculate
the numbers without filtering (\code{filt = NULL}) using this function and then
perform your desired filtering routine on the result. If there are many
channels, this may be specified as a vector, one element for each channel.}

\item{s}{A positive number. The \eqn{S}-factor of microscope acquisition.}

\item{offset}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{readout_noise}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\description{
Perform \code{\link[=brightness_timeseries]{brightness_timeseries()}} calculations on all tif images in a folder
and save the resulting number images to disk.
}
\examples{
\dontrun{
setwd(tempdir())
img <- ijtiff::read_tif(system.file("extdata", "50.tif", package = "nandb"))
ijtiff::write_tif(img, "img1.tif")
ijtiff::write_tif(img, "img2.tif")
brightness_timeseries_folder(def = "e", thresh = "tri", frames_per_set = 20)
}
}
\seealso{
\code{\link[=brightness_timeseries]{brightness_timeseries()}}
}
