% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-zero.R
\name{impute_zero}
\alias{impute_zero}
\title{Impute zero into a vector with missing values}
\usage{
impute_zero(x)
}
\arguments{
\item{x}{vector}
}
\value{
vector with a fixed values replaced
}
\description{
This can be useful if you are imputing specific values, however we would
generally recommend to impute using other model based approaches. See
the \code{simputation} package, for example \code{\link[simputation:impute_lm]{simputation::impute_lm()}}.
}
\examples{

vec <- rnorm(10)

vec[sample(1:10, 3)] <- NA

vec

impute_zero(vec)

library(dplyr)

dat <- tibble(
  num = rnorm(10),
  int = rpois(10, 5),
  fct = factor(LETTERS[1:10])
) \%>\%
  mutate(
    across(
      everything(),
      \(x) set_prop_miss(x, prop = 0.25)
    )
  )

dat

dat \%>\%
  nabular() \%>\%
  mutate(
    num = impute_fixed(num, -9999),
    int = impute_zero(int),
    fct = impute_factor(fct, "out")
  )

}
