% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na_with.R
\name{replace_na_with}
\alias{replace_na_with}
\title{Replace NA value with provided value}
\usage{
replace_na_with(x, value)
}
\arguments{
\item{x}{vector}

\item{value}{value to replace}
}
\value{
vector with replaced values
}
\description{
This function helps you replace NA values with a single provided value.
This can be classed as a kind of imputation, and is powered by
\code{\link[=impute_fixed]{impute_fixed()}}. However, we would generally recommend to impute using
other model based approaches. See the \code{simputation} package, for example
\code{\link[simputation:impute_lm]{simputation::impute_lm()}}. See \code{\link[tidyr:replace_na]{tidyr::replace_na()}} for a slightly
different approach, \code{\link[dplyr:coalesce]{dplyr::coalesce()}} for replacing NAs with values from
other vectors, and \code{\link[dplyr:na_if]{dplyr::na_if()}} to replace specified values with NA.
}
\examples{

library(naniar)
x <- c(1:5, NA, NA, NA)
x
replace_na_with(x, 0L)
replace_na_with(x, "unknown")

library(dplyr)
dat <- tibble(
  ones = c(NA,1,1),
  twos = c(NA,NA, 2),
  threes = c(NA, NA, NA)
)

dat

dat \%>\%
  mutate(
    ones = replace_na_with(ones, 0),
    twos = replace_na_with(twos, -99),
    threes = replace_na_with(threes, "unknowns")
  )

dat \%>\%
  mutate(
    across(
      everything(),
      \(x) replace_na_with(x, -99)
    )
  )

}
