% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunks.R
\name{make_chunks}
\alias{make_chunks}
\title{Split inputs into a number of chunks}
\usage{
make_chunks(x, size = length(x), nchunks = NULL, chunksize = NULL)
}
\arguments{
\item{x}{A vector of inputs e.g. ids, neurons etc (optional, see examples)}

\item{size}{The number of inputs (defaults to \code{length(x)} when \code{x}
is present)}

\item{nchunks}{The desired number of chunks}

\item{chunksize}{The desired number of items per chunk}
}
\value{
The elements of x split into a list of chunks or (when \code{x} is
  missing) a vector of integer indices in the range \code{1:nchunks}
  specifying the chunk for each input element .
}
\description{
Split inputs into a number of chunks
}
\details{
You must specify exactly one of \code{nchunks} and \code{chunksize}.
}
\examples{
make_chunks(1:11, nchunks=2)
make_chunks(size=11, chunksize=2)
}
