% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nca.npde.plot.R
\name{nca.npde.plot}
\alias{nca.npde.plot}
\title{Plots population histogram of the NCA metrics selected for model diagnosis.}
\usage{
nca.npde.plot(
  plotdata,
  xvar = NULL,
  npdecol = NULL,
  figlbl = NULL,
  cunit = NULL,
  tunit = NULL
)
}
\arguments{
\item{plotdata}{Data frame with the values of the NPDE values of each
individual for the NCA metrics}

\item{xvar}{Name of the independent variable column against which NPDE values
will be plotted}

\item{npdecol}{Column names or column numbers of containing the NPDE values}

\item{figlbl}{Figure label based on dose identifier and/or population
stratifier (\strong{NULL})}

\item{cunit}{Unit for concentration (default is \strong{\code{NULL}})}

\item{tunit}{Unit for time (default is \strong{\code{NULL}})}
}
\value{
returns a data frame with the mean and SD of population NPDE values
  of each NCA metric and two graphical objects created by arrangeGrob
  function for the individual and population histogram of the NPDE values
}
\description{
\pkg{nca.npde.plot} plots individual NPDE values and histogram of the NPDE
values within a population group
}
\details{
\pkg{nca.npde.plot} individual NPDE values and histogram of the NPDE
values of NCA metrics within a population group.
}
