% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fossep_distribution.R
\name{fossep}
\alias{fossep}
\alias{dfossep}
\alias{pfossep}
\alias{qfossep}
\alias{rfossep}
\title{Fernandez-Osiewalski-Steel Skew Exponential Power Distribution}
\usage{
dfossep(x, mu = 0, sigma = 1, alpha = 2, beta = 2, log = FALSE)

pfossep(
  q,
  mu = 0,
  sigma = 1,
  alpha = 2,
  beta = 2,
  lower.tail = TRUE,
  log.p = FALSE
)

qfossep(
  p,
  mu = 0,
  sigma = 1,
  alpha = 2,
  beta = 2,
  lower.tail = TRUE,
  log.p = FALSE
)

rfossep(n, mu = 0, sigma = 1, alpha = 2, beta = 2)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{a location parameter.}

\item{sigma}{a scale parameter.}

\item{alpha}{a shape parameter (skewness).}

\item{beta}{a shape parameter (kurtosis).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)
The default value of this parameter is FALSE}

\item{lower.tail}{logical;if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vectors of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dfossep} gives the density , \code{pfossep} gives the distribution function,
\code{qfossep} gives quantiles function, \code{rfossep} generates random numbers.
}
\description{
To calculate density function, distribution function, quantile function, and  build data from random generator function 
for the Fernandez-Osiewalski-Steel Skew Exponential Power Distribution.
}
\details{
Fernandez-Osiewalski-Steel Skew Exponential Power Distribution 



The Fernandez-Osiewalski-Steel Skew Exponential Power distribution with parameters \eqn{\mu}, \eqn{\sigma},\eqn{\alpha}, and \eqn{\beta}
has density:
\deqn{f(x |\mu,\sigma,\beta,\alpha) = \frac{c}{\sigma} \exp \left( - \frac{1}{2} \left| v z \right|^\tau \right) \quad \text{if } x < \mu}
\deqn{f(x |\mu,\sigma,\beta,\alpha) = \frac{c}{\sigma} \exp \left( - \frac{1}{2} \left| \frac{v}{z} \right|^\tau \right) \quad \text{if } x \ge \mu}
\deqn{ \text{where } -\infty < y < \infty, \ -\infty < \mu < \infty, \ \sigma > 0, \ \alpha > 0, \ \beta > 0}
\deqn{ z = \frac{x - \mu}{\sigma}}
\deqn{ c = v \tau \left[ (1 + v^2) 2^{\frac{1}{\tau}} \Gamma \left( \frac{1}{\tau} \right) \right]^{-1}}
}
\examples{
dfossep(4, mu=0, sigma=1, alpha=2, beta=2)
pfossep(4, mu=0, sigma=1, alpha=2, beta=2)
qfossep(0.4, mu=0, sigma=1, alpha=2, beta=2)
rfossep(4, mu=0, sigma=1, alpha=2, beta=2)
}
\references{
Fernandez, C., Osiewalski, J., & Steel, M. F. (1995) Modeling and inference with v-spherical distributions.
 Journal of the American Statistical Association, 90(432), pp 1331-1340.

 Rigby, R.A. and Stasinopoulos, M.D. and Heller, G.Z. and De Bastiani, F. 
  (2019) Distributions for Modeling Location, Scale, 
  and Shape: Using GAMLSS in R.CRC Press
}
\author{
Almira Utami
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
