% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{brd_countdata}
\alias{brd_countdata}
\title{Count data table from Breeding landbird point counts (DP1.10003.001)}
\format{
A data frame with 472 rows and 26 columns
\describe{
  \item{uid}{Unique ID within NEON database; an identifier for the record}
  \item{namedLocation}{Name of the measurement location in the NEON database}
  \item{domainID}{Unique identifier of the NEON domain}
  \item{siteID}{NEON site code}
  \item{plotID}{Plot identifier (NEON site code_XXX)}
  \item{plotType}{NEON plot type in which sampling occurred: tower, distributed or gradient}
  \item{pointID}{Identifier for a point location}
  \item{startDate}{The start date-time or interval during which an event occurred}
  \item{eventID}{An identifier for the set of information associated with the event, which includes information about the place and time of the event}
  \item{pointCountMinute}{The minute of sampling within the point count period}
  \item{targetTaxaPresent}{Indicator of whether the sample contained individuals of the target taxa}
  \item{taxonID}{Species code, based on one or more sources}
  \item{scientificName}{Scientific name, associated with the taxonID. This is the name of the lowest level taxonomic rank that can be determined}
  \item{taxonRank}{The lowest level taxonomic rank that can be determined for the individual or specimen}
  \item{vernacularName}{A common or vernacular name}
  \item{family}{The scientific name of the family in which the taxon is classified}
  \item{nativeStatusCode}{The process by which the taxon became established in the location}
  \item{observerDistance}{Radial distance between the observer and the individual(s) being observed}
  \item{detectionMethod}{How the individual(s) was (were) first detected by the observer}
  \item{visualConfirmation}{Whether the individual(s) was (were) seen after the initial detection}
  \item{sexOrAge}{Sex of individual if detectable, age of individual if individual can not be sexed}
  \item{clusterSize}{Number of individuals in a cluster (a group of individuals of the same species)}
  \item{clusterCode}{Alphabetic code (A-Z) linked to clusters (groups of individuals of the same species) spanning multiple records}
  \item{identifiedBy}{An identifier for the technician who identified the specimen}
  \item{publicationDate}{Date of data publication on the NEON data portal}
  \item{release}{Identifier for data release}
}
}
\source{
\url{https://data.neonscience.org/api/v0/products/DP1.10003.001}
}
\usage{
brd_countdata
}
\description{
An example set of NEON observational data. Contains the individual bird observations from Niwot Ridge (NIWO) in 2019, as published in RELEASE-2021.
}
\keyword{datasets}
