% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_inc_matrix.R
\name{reduce_inc_matrix}
\alias{reduce_inc_matrix}
\title{Reduce size of incidence matrix for downstream analyses}
\usage{
reduce_inc_matrix(incM)
}
\arguments{
\item{incM}{a \code{logical} \code{matrix} containing the incidence matrix
with its column and row names (respectively, protein and peptide identifiers)
and 0 or 1 values indicating whether or not the peptide maps on the
corresponding protein.}
}
\value{
a \code{logical} \code{matrix} containing a smaller incidence matrix
(with column and row names respectively reporting protein and peptide
identifiers) and 0 or 1 values indicating whether or not the peptide maps on
the corresponding protein. Only proteins with at least one shared peptide and
all peptides mapping on such protein are reported in such reduced incidence
matrix.
}
\description{
Reduce the size of the incidence matrix describing peptide-to-protein
mappings to ease downstream analyses. The original incidence matrix is
reduced to only contain proteins with at least one shared peptide and all
peptides mapping on such proteins. This means that only proteins ambiguously
identified are retained, which is the most interesting ones when studying
ambiguity of protein identifications.
}
\examples{
# Read the tab-delimited file containing he proteome incidence matrix
incM_filename <- system.file("extdata"
                             , "incM_example"
                             , package = "net4pg"
                             , mustWork = TRUE)
rownames_filename <- system.file("extdata"
                                  , "peptideIDs_incM_example"
                                  , package = "net4pg"
                                  , mustWork = TRUE)
colnames_filename <- system.file("extdata"
                                 , "proteinIDs_incM_example"
                                 , package = "net4pg"
                                 , mustWork = TRUE)
incM <- read_inc_matrix(incM_filename = incM_filename
                 , colnames_filename = colnames_filename
                 , rownames_filename = rownames_filename)
# Only retain proteins with at least one shared peptide and all peptides
# mapping on such proteins.
incM_reduced <- reduce_inc_matrix(incM)

}
\author{
Laura Fancello
}
