% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.netSEMp2.R
\name{plot.netSEMp2}
\alias{plot.netSEMp2}
\title{Plotting of netSEM diagram}
\usage{
\method{plot}{netSEMp2}(
  x,
  cutoff = c(0.3, 0.6, 0.8),
  latent = NULL,
  plot.save = FALSE,
  filename = NULL,
  style = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class "netSEMp2", the returned list from \code{netSEMp2}.}

\item{cutoff}{A threshold value for adjusted R-squared. The maximum number of cutoff is 3.}

\item{latent}{The latent variable that corresponds to the mechanic variable. The default is NULL.}

\item{plot.save}{True/False, it saves the network diagram plot as png file. The default is false.}

\item{filename}{A character string naming a file to save as a png file.}

\item{style}{True/False, it plots the first interval in the network diagram with dotted weak line. The default is True.}

\item{...}{A S3 generic/method consistency.}
}
\value{
An html style plot of multiple regression relationship pathway diagram between exogenous variables and an endogenous variable. 
Arrows show relationships between each variable with given statistical relations along the connection lines.
}
\description{
Plot netSEMp2 result
plot.netSEMp2 plots a network structural equation model diagram, fitted under principle 2, based on best functional form for each selected pairwise variable.
}
\examples{
\dontrun{
# Load acrylic data set
data(acrylic)

# Build a netSEMp2 model
ans2 <- netSEMp2(acrylic, criterion = "AIC")
ans2_BIC <- netSEMp2(acrylic, criterion = "BIC")

# Plot the network model 
plot(ans2, cutoff = c(0.3,0.6,0.8))
plot(ans2_BIC , cutoff = c(0.3,0.6,0.8))

# Drop Relationship lower than minimum cutoff
plot(ans2, cutoff = c(0.3,0.6,0.8), style = FALSE)

# plot network model with latent argument labels
plot(ans2, cutoff = c(0.3, 0.6, 0.8), 
     latent = c('IAD1' = 'FundAbsEdge', 
                'IAD2' = 'UVStab', 
                'IAD2p' = 'UVStab', 
                'IAD3' = 'YelMet'))

# plot the network diagram and save file
#plot(ans, cutoff = c(0.3,0.6,0.8), plot.save = TRUE, filename = "acrylic-netSEMp2"))
}
}
\seealso{
\link[netSEM]{netSEMp2}
}
