% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stir_PA.R
\name{stir_PA}
\alias{stir_PA}
\title{Stirs a Preferential Attachment Network}
\usage{
stir_PA(
  matrix,
  x,
  power,
  directed = TRUE,
  retcon = FALSE,
  sum_v_max = "max",
  nascent_help = TRUE
)
}
\arguments{
\item{matrix}{Existing network to experience growth.}

\item{x}{The ID of the node to be rewired (stirred).}

\item{power}{Power of attachment, which determines how much new nodes prefer to attach to nodes that have many edges compared to few. Needs to be positive.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix.}

\item{retcon}{Binary variable determining if already existing nodes can attach to new nodes. Defaults to FALSE.}

\item{sum_v_max}{Degree distributions must be normalized, either by their "max" or "sum". Defaults to "max".}

\item{nascent_help}{Should a single edge be added to the degree distribution of all nodes so that nodes with a zero in-degree can still have a chance of being attached to by new nodes. Defaults to TRUE.}
}
\value{
An adjacency matrix.
}
\description{
Stirs an already existing network by rewiring a node according to the Preferential Attachment mechanism.
}
\details{
Rewires a node in a network according to the Preferential Attachment mechanism.
}
\examples{
# Import netcom
library(netcom)

size <- 10
existing_network <- matrix(sample(c(0,1), size = size^2, replace = TRUE), nrow = size, ncol = size)
new_network_prep <- matrix(0, nrow = size + 1, ncol = size + 1)
new_network_prep[1:size, 1:size] = existing_network
new_network <- stir_PA(matrix = new_network_prep, x = size + 1, power = 2.15)

}
\references{
Barabási, A. L., & Albert, R. (1999). Emergence of scaling in random networks. science, 286(5439), 509-512.
}
