% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-sitrep.R
\name{ns_validate_client_pattern}
\alias{ns_validate_client_pattern}
\alias{ns_validate_client_id}
\alias{ns_validate_client_secret}
\title{Validate Nettskjema Client Pattern}
\usage{
ns_validate_client_pattern(x, type = c("id", "secret"))

ns_validate_client_id(x)

ns_validate_client_secret(x)
}
\arguments{
\item{x}{A character string to validate.}

\item{type}{The identifier type to
validate (`"id"` or `"secret"`).}
}
\value{
A logical value: `TRUE` if the
    input format is valid, otherwise
}
\description{
Validates the format of Nettskjema client
 identifiers such as the `NETTSKJEMA_CLIENT_ID`
or `NETTSKJEMA_CLIENT_SECRET`. Returns
`TRUE` if the input matches the required
format, and `FALSE` otherwise.
}
\details{
- `"id"` validation expects a UUID format:
`xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx`.
- `"secret"` validation expects a
72-character alphanumeric string.
}
\section{Functions}{
\itemize{
\item \code{ns_validate_client_id()}: Validate Nettskjema Client ID

\item \code{ns_validate_client_secret()}: Validate Nettskjema Client Secret

}}
\examples{
client_id <- "a1b2c3d4-e5f6-7890-abcd-ef1234567890"
ns_validate_client_pattern(client_id,
type = "id")
ns_validate_client_id(client_id)


client_secret <- "aB3xK9mP2vQ8_R7nL98Mcs81sT4uY6wE5zC0hJ9iO3kM8pN2qA7bD1gF4jH6lS-9vX3nR5mT" #nolint
ns_validate_client_pattern(client_secret,
type = "secret")
ns_validate_client_secret(client_secret)

}
