% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R
\name{grid_to_coord}
\alias{grid_to_coord}
\alias{grid_to_coord,NeuroSpace,matrix-method}
\alias{grid_to_coord,NeuroSpace,numeric-method}
\alias{grid_to_coord,NeuroVol,matrix-method}
\title{Generic function to convert N-dimensional grid coordinates to real world coordinates}
\usage{
grid_to_coord(x, coords)

\S4method{grid_to_coord}{NeuroSpace,matrix}(x, coords)

\S4method{grid_to_coord}{NeuroSpace,matrix}(x, coords)

\S4method{grid_to_coord}{NeuroSpace,numeric}(x, coords)

\S4method{grid_to_coord}{NeuroVol,matrix}(x, coords)
}
\arguments{
\item{x}{the object}

\item{coords}{a matrix of grid coordinates}
}
\value{
A numeric \code{matrix} of real-world coordinates.
}
\description{
Generic function to convert N-dimensional grid coordinates to real world coordinates
}
\examples{
# Create a simple 3D volume
bvol <- NeuroVol(array(0, c(10,10,10)), NeuroSpace(c(10,10,10), c(1,1,1)))
grid_coords <- matrix(c(1.5,1.5,1.5, 5.5,5.5,5.5), ncol=3, byrow=TRUE)
world <- grid_to_coord(bvol, grid_coords)
grid <- coord_to_grid(bvol, world)
all.equal(grid_coords, grid)
}
