% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/clustervol.R,
%   R/filebacked_neurovec.R, R/mapped_neurovec.R, R/neurohypervec.R,
%   R/neuroslice.R, R/neurovec.R, R/neurovol.R, R/sparse_neurovec.R
\name{mask}
\alias{mask}
\alias{mask,ClusteredNeuroVol-method}
\alias{mask,FileBackedNeuroVec-method}
\alias{mask,MappedNeuroVec-method}
\alias{mask,NeuroHyperVec-method}
\alias{mask,NeuroSlice-method}
\alias{mask,DenseNeuroVec-method}
\alias{mask,DenseNeuroVol-method}
\alias{mask,LogicalNeuroVol-method}
\alias{mask,AbstractSparseNeuroVec-method}
\alias{mask,SparseNeuroVecSource-method}
\title{Extract Mask from Neuroimaging Object}
\usage{
mask(x)

\S4method{mask}{ClusteredNeuroVol}(x)

\S4method{mask}{FileBackedNeuroVec}(x)

\S4method{mask}{MappedNeuroVec}(x)

\S4method{mask}{NeuroHyperVec}(x)

\S4method{mask}{NeuroSlice}(x)

\S4method{mask}{DenseNeuroVec}(x)

\S4method{mask}{DenseNeuroVol}(x)

\S4method{mask}{LogicalNeuroVol}(x)

\S4method{mask}{AbstractSparseNeuroVec}(x)

\S4method{mask}{SparseNeuroVecSource}(x)
}
\arguments{
\item{x}{A neuroimaging object (NeuroVol, NeuroVec, or derived classes)}
}
\value{
A \code{\linkS4class{LogicalNeuroVol}} object representing the mask
}
\description{
Generic function to extract or generate a mask from neuroimaging objects.
For sparse objects with a \code{@mask} slot, returns the stored mask.
For dense objects, returns a filled mask (all TRUE values) indicating
all voxels contain valid data.
}
\details{
The behavior depends on the class of the input object:
\itemize{
  \item For sparse objects (SparseNeuroVec, ClusteredNeuroVol, etc.): 
        Returns the stored \code{@mask} slot
  \item For dense objects (DenseNeuroVol, DenseNeuroVec, etc.): 
        Returns a LogicalNeuroVol with all TRUE values
  \item For ROI objects: Not implemented (use \code{coords()} instead)
}
}
\examples{
# Create a dense volume
vol <- NeuroVol(array(rnorm(64^3), c(64,64,64)), NeuroSpace(c(64,64,64)))
m <- mask(vol)  # Returns all TRUE mask

# Create a sparse vector with explicit mask
mask_array <- array(runif(64^3) > 0.5, c(64,64,64))
mask_vol <- LogicalNeuroVol(mask_array, NeuroSpace(c(64,64,64)))
# Data must be a matrix (time x masked voxels)
sparse_data <- matrix(rnorm(sum(mask_array) * 10), nrow = 10, ncol = sum(mask_array))
svec <- SparseNeuroVec(sparse_data, NeuroSpace(c(64,64,64,10)), mask_vol)
m2 <- mask(svec)  # Returns the stored mask

}
