% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_info_api.R
\name{meta_info}
\alias{meta_info}
\alias{meta_info,FileMetaInfo-method}
\alias{meta_info,character-method}
\title{Lightweight metadata for neuroimaging files}
\usage{
meta_info(x)

\S4method{meta_info}{FileMetaInfo}(x)

\S4method{meta_info}{character}(x)
}
\arguments{
\item{x}{A character file path (e.g., `"image.nii.gz"`) or an object of
class \code{\linkS4class{FileMetaInfo}}.}
}
\value{
A named list with the following elements:
\itemize{
  \item `dim` Integer vector of image dimensions.
  \item `spacing` Numeric voxel spacing (mm).
  \item `origin` Numeric coordinate origin.
  \item `trans` 4x4 transformation matrix mapping grid to world (mm).
  \item `path` Data file path.
  \item `filename` Basename of `path`.
  \item `format` File format label (e.g., "NIFTI", "AFNI").
  \item `dtype` Storage data type label.
  \item `bytes_per_element` Bytes per element.
  \item `nvox` Number of voxels in the spatial volume (prod of first 3 dims).
  \item `nvol` Number of volumes (4th dim if present, else 1).
  \item `size_bytes` Approximate uncompressed size in bytes (`nvox * nvol * bytes_per_element`).
  \item `time_step` Time step (TR in seconds) if available for NIfTI, else `NA_real_`.
}
}
\description{
`meta_info()` provides a simple, CRAN-friendly way to retrieve essential
image metadata without teaching S4 details up front. It accepts a file
path or a `FileMetaInfo` object and returns a normalized list containing
common fields like dimensions, spacing, origin, and transform.

The function does not read image data; it only parses header information.
}
\details{
Summarize Image Metadata
}
\examples{
\donttest{
f <- system.file("extdata", "global_mask_v4.nii", package = "neuroim2")
mi <- meta_info(f)
mi$dim
mi$spacing
mi$origin
mi$filename
# 4x4 transform
mi$trans
}

}
\seealso{
\code{\link{read_header}}, \code{\link{trans}},
  \code{\linkS4class{FileMetaInfo}}, \code{\linkS4class{NIFTIMetaInfo}}
}
