% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/clustered_neurovec.R,
%   R/neurovol.R, R/roi.R
\name{values}
\alias{values}
\alias{values,ClusteredNeuroVec-method}
\alias{values,DenseNeuroVol-method}
\alias{values,SparseNeuroVol-method}
\alias{values,ROIVol-method}
\alias{values,ROIVec-method}
\title{Extract Data Values of an Object}
\usage{
values(x, ...)

\S4method{values}{ClusteredNeuroVec}(x)

\S4method{values}{DenseNeuroVol}(x)

\S4method{values}{SparseNeuroVol}(x)

\S4method{values}{ROIVol}(x, ...)

\S4method{values}{ROIVec}(x, ...)
}
\arguments{
\item{x}{the object to get values from}

\item{...}{additional arguments}
}
\value{
A vector or array containing the values extracted from \code{x}.
}
\description{
Extract Data Values of an Object
}
\examples{
x <- NeuroSpace(c(10,10,10), c(1,1,1))
vol <- NeuroVol(rnorm(10 * 10 * 10), x)
values(vol)
}
