% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovol.R
\name{write_vol}
\alias{write_vol}
\alias{write_vol,NeuroVol,character,missing,missing-method}
\alias{write_vol,ClusteredNeuroVol,character,missing,missing-method}
\alias{write_vol,NeuroVol,character,character,missing-method}
\alias{write_vol,ROIVol,character,character,missing-method}
\alias{write_vol,NeuroVol,character,missing,character-method}
\title{Write a 3d image volume to disk}
\usage{
write_vol(x, file_name, format, data_type)

\S4method{write_vol}{NeuroVol,character,missing,missing}(x, file_name)

\S4method{write_vol}{ClusteredNeuroVol,character,missing,missing}(x, file_name)

\S4method{write_vol}{NeuroVol,character,character,missing}(x, file_name, format)

\S4method{write_vol}{ROIVol,character,character,missing}(x, file_name, format)

\S4method{write_vol}{NeuroVol,character,missing,character}(x, file_name, data_type)
}
\arguments{
\item{x}{an image object, typically a \code{\linkS4class{NeuroVol}} instance.}

\item{file_name}{output file name}

\item{format}{file format string. Since "NIFTI" is the only currently supported format, this parameter can be safely ignored and omitted.}

\item{data_type}{output data type, If specified should be a \code{character} vector of: "BINARY", "UBYTE", "SHORT", "INT", "FLOAT", "DOUBLE".
Otherwise output format will be inferred from R the datatype of the image.}
}
\value{
Invisibly returns \code{NULL} after writing the volume to disk.
}
\description{
Write a 3d image volume to disk
}
\details{
The output format will be inferred from file extension.

The output format will be inferred from file extension.
 \code{write_vol(x, "out.nii")} outputs a NIFTI file.
 \code{write_vol(x, "out.nii.gz")} outputs a gzipped NIFTI file.

No other file output formats are currently supported.
}
\examples{

bvol <- NeuroVol(array(0, c(10,10,10)), NeuroSpace(c(10,10,10), c(1,1,1)))
\donttest{
tmp1 <- tempfile(fileext = ".nii")
write_vol(bvol, tmp1)
unlink(tmp1)
}
}
