% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R, R/BrainVolume.R
\docType{class}
\name{SparseBrainVolume-class}
\alias{SparseBrainVolume}
\alias{SparseBrainVolume-class}
\title{SparseBrainVolume}
\usage{
SparseBrainVolume(data, space, indices = NULL, source = NULL, label = "")
}
\arguments{
\item{data}{a numeric vector}

\item{space}{an instance of class \code{\linkS4class{BrainSpace}}}

\item{indices}{a index vector indicating the 1-d coordinates of the data values}

\item{source}{an instance of class \code{\linkS4class{BrainSource}}}

\item{label}{a \code{character} string}
}
\value{
\code{\linkS4class{SparseBrainVolume}} instance
}
\description{
Three-dimensional brain image, backed by a \code{sparseVector} for \code{Matrix} package

Construct a \code{\linkS4class{SparseBrainVolume}} instance
}
\details{
Image data is backed by \code{Matrix::sparseVector}.
}
\section{Slots}{

\describe{
\item{\code{data}}{a \code{sparseVector} instance}
}}
\examples{
data <- 1:10
indices <- seq(1,1000, length.out=10)
bspace <- BrainSpace(c(64,64,64), spacing=c(1,1,1))
sparsevol <- SparseBrainVolume(data,bspace,indices=indices)
densevol <- BrainVolume(data,bspace,indices=indices)
sum(sparsevol) == sum(densevol)



}

