% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainData.R, R/BrainSpace.R, R/IndexLookupVolume.R
\docType{methods}
\name{space}
\alias{space}
\alias{space,BrainData-method}
\alias{space,BrainSpace-method}
\alias{space,IndexLookupVolume-method}
\title{Generic function to extract geometric properties of an image.}
\usage{
space(x, ...)

\S4method{space}{BrainData}(x)

\S4method{space}{BrainSpace}(x)

\S4method{space}{IndexLookupVolume}(x)
}
\arguments{
\item{x}{the object to query, e.g. an instance of \code{BrainVolume} or \code{BrainVector}}

\item{...}{additional arguments}
}
\value{
an object representing the geometric space of the image of type \code{\linkS4class{BrainSpace}}
}
\description{
Generic function to extract geometric properties of an image.
}
\examples{
x = BrainSpace(c(10,10,10), c(1,1,1))
vol <- BrainVolume(rnorm(10*10*10), x)
identical(x,space(vol))

}

