% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{statistics}
\alias{statistics}
\alias{stat_student_euclidean}
\alias{stat_welch_euclidean}
\alias{stat_original_edge_count}
\alias{stat_generalized_edge_count}
\alias{stat_weighted_edge_count}
\title{Test Statistics for Network Populations}
\usage{
stat_student_euclidean(d, indices, ...)

stat_welch_euclidean(d, indices, ...)

stat_original_edge_count(d, indices, edge_count_prep, ...)

stat_generalized_edge_count(d, indices, edge_count_prep, ...)

stat_weighted_edge_count(d, indices, edge_count_prep, ...)
}
\arguments{
\item{d}{Either a matrix of dimension \eqn{(n1+n2)x(n1+n2)} containing the
distances between all the elements of the two samples put together (for
distance-based statistics) or the concatenation of the lists of matrix
representations of networks in samples 1 and 2 for Euclidean t-Statistics.}

\item{indices}{A vector of dimension \eqn{n1} containing the indices of the
elements of the first sample.}

\item{...}{Extra parameters specific to some statistics.}

\item{edge_count_prep}{A list of preprocessed data information used by edge
count statistics and produced by \code{\link{edge_count_global_variables}}.}
}
\value{
A scalar giving the value of the desired test statistic.
}
\description{
This is a collection of functions that provide statistics for testing
equality in distribution between samples of networks.
}
\details{
In details, there are three main categories of statistics:
\itemize{
\item \emph{Euclidean t-Statistics}: both Student \code{stat_student_euclidean} version for
equal variances and Welch \code{stat_welch_euclidean} version for unequal
variances,
\item \emph{Statistics based on similarity graphs}: 3 types of edge count statistics.
}
}
\examples{
n1 <- 30L
n2 <- 10L
gnp_params <- list(p = 1/3)
k_regular_params <- list(k = 8L)
x <- nvd(model = "gnp", n = n1, model_params = gnp_params)
y <- nvd(model = "k_regular", n = n2, model_params = k_regular_params)
r <- repr_nvd(x, y, representation = "laplacian")
stat_student_euclidean(r, 1:n1)
stat_welch_euclidean(r, 1:n1)
d <- dist_nvd(x, y, representation = "laplacian", distance = "frobenius")
ecp <- edge_count_global_variables(d, n1, k = 5L)
stat_original_edge_count(d, 1:n1, edge_count_prep = ecp)
stat_generalized_edge_count(d, 1:n1, edge_count_prep = ecp)
stat_weighted_edge_count(d, 1:n1, edge_count_prep = ecp)
}
