% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dNmixture_steps}
\alias{dNmixture_steps}
\alias{nimNmixPois_logFac}
\alias{dNmixture_BNB_steps}
\alias{dNmixture_BBP_steps}
\alias{dNmixture_BBNB_steps}
\title{Internal helper nimbleFunctions for dNmixture distributions}
\usage{
nimNmixPois_logFac(numN, ff, max_index = -1)

dNmixture_steps(
  x,
  lambda,
  Nmin,
  Nmax,
  sum_log_one_m_prob,
  sum_log_dbinom,
  usingAD = FALSE
)

dNmixture_BNB_steps(
  x,
  lambda,
  theta,
  Nmin,
  Nmax,
  sum_log_one_m_prob,
  sum_log_dbinom,
  usingAD = FALSE
)

dNmixture_BBP_steps(
  x,
  beta_m_x,
  lambda,
  s,
  Nmin,
  Nmax,
  sum_log_dbetabinom,
  usingAD = FALSE
)

dNmixture_BBNB_steps(
  x,
  beta_m_x,
  lambda,
  theta,
  s,
  Nmin,
  Nmax,
  sum_log_dbetabinom,
  usingAD = FALSE
)
}
\arguments{
\item{numN}{number of indices in the truncated sum for the N-mixture.}

\item{ff}{a derived vector of units calculated partway through the fast
N-mixture algorithm.}

\item{max_index}{possibly the index of the max contribution to the summation.
For AD cases this is set by heuristic. For non-AD cases it is -1 and will
be determined automatically.}

\item{x}{x from dNmixture distributions}

\item{lambda}{lambda from dNmixture distributions}

\item{Nmin}{start of summation over N}

\item{Nmax}{end of summation over N}

\item{sum_log_one_m_prob}{sum(log(1-prob)) from relevant dNmixture cases}

\item{sum_log_dbinom}{sum(log(dbinom(...))) from relevant dNmixture cases}

\item{usingAD}{TRUE if called from one of the dNmixtureAD distributions}

\item{theta}{theta from relevant dNmixture distributions}

\item{beta_m_x}{beta-x from relevant dNmixture cases}

\item{s}{s from relevant dNmixture distributions}

\item{sum_log_dbetabinom}{sum(log(dBetaBinom(...))) from relevant dNmixture
cases}
}
\description{
None of these functions should be called directly.
}
\details{
These are helper functions for the N-mixture calculations. They
  don't have an interpretation outside of that context and are not intended
  to be called directly.
}
\seealso{
\code{\link{dNmixture}}
}
