% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBaseline.R
\name{addBaselineConst}
\alias{addBaselineConst}
\title{Add an estimated baseline constant}
\usage{
addBaselineConst(ui, effect = "effect", eb = "Eb")
}
\arguments{
\item{ui}{rxode2 model}

\item{effect}{the effect variable that will be modeled}

\item{eb}{baseline constant parameter}
}
\value{
model with baseline constant
}
\description{
Add an estimated baseline constant
}
\examples{
readModelDb("PK_2cmt_no_depot") |>
  addDirectLin() |>
  convertQuad() |>
  addBaselineConst()
}
\seealso{
Other PD: 
\code{\link{addBaseline1exp}()},
\code{\link{addBaselineExp}()},
\code{\link{addBaselineLin}()},
\code{\link{addDirectLin}()},
\code{\link{convertEmax}()},
\code{\link{convertLogLin}()},
\code{\link{convertQuad}()}
}
\author{
Matthew L. Fidler
}
\concept{PD}
