% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWeibullAbs.R
\name{addWeibullAbs}
\alias{addWeibullAbs}
\title{Converts first order absorption model to Weibull absorption model}
\usage{
addWeibullAbs(
  ui,
  ntransit,
  central = "central",
  depot = "depot",
  transit = "transit",
  wa = "wa",
  wb = "wb",
  ka = "ka",
  ktr = "ktr"
)
}
\arguments{
\item{ui}{The model as a function}

\item{ntransit}{the number of transit compartments to be added}

\item{central}{central compartment name}

\item{depot}{depot compartment name}

\item{transit}{the transit compartment prefix}

\item{wa}{Weibull alpha parameter name}

\item{wb}{Weibull beta parameter name}

\item{ka}{absorption rate parameter name}

\item{ktr}{the parameter name for the transit compartment rate}
}
\value{
model where first order absorption is changed to Weibull absorption model
}
\description{
Converts first order absorption model to Weibull absorption model
}
\examples{
readModelDb("PK_1cmt_des") |>
  addWeibullAbs()
}
\seealso{
Other absorption: 
\code{\link{addTransit}()},
\code{\link{removeTransit}()}
}
\author{
Matthew L. Fidler
}
\concept{absorption}
