% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuEST_wrappers.R
\name{ESD}
\alias{ESD}
\title{Compute the empirical spectral distribution (ESD) for a set of population
eigenvalues}
\usage{
ESD(tau, n)
}
\arguments{
\item{tau}{(Required) A non-negative numeric vector of population
eigenvalues.}

\item{n}{(Required) A positive integer representing the number of datapoints
of a hypothetical data matrix with dimension \code{c(n, p = length(tau))}.}
}
\value{
A named numeric vector of containing points of the ESD. The names
  give the corresponding points on the x axis.
}
\description{
The Marcenko Pastur (MP) law relates the limiting distribution
  of the sample eigenvalues to that of the population eigenvalues. In the
  finite-dimensional case, the population spectral distribution (PSD) can be
  represented as a sum of point masses, and the empirical spectral
  distribution (ESD) can be obtained by solving the discretized MP equation.
  Theoretical and implementation details in the references.
}
\examples{
tau_ESD <- ESD(tau = rep(1,200), n = 300)
plot(names(tau_ESD), tau_ESD, ylab="F(x)", xlab="x")
}
\references{
\itemize{ \item Ledoit, O. and Wolf, M. (2015). Spectrum
  estimation: a unified framework for covariance matrix estimation and PCA in
  large dimensions. Journal of Multivariate Analysis, 139(2) \item Ledoit, O.
  and Wolf, M. (2016). Numerical Implementation of the QuEST function.
  arXiv:1601.05870 [stat.CO] }
}

