% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_Clemente2012}
\alias{bins_Clemente2012}
\title{NMR grouping bins from Clemente et al. (2012).}
\format{
A data frame with 6 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
JS Clemente et al. 2012. “Comparison of Nuclear Magnetic Resonance
Methods for the Analysis of Organic Matter Composition from Soil Density and
Particle Fractions.” Environmental Chemistry
\doi{10.1071/EN11096}
}
\usage{
bins_Clemente2012
}
\description{
NMR grouping bins from Clemente et al. (2012), using DMSO-D6 as solvent.
(1) aliphatic polymethylene and methyl groups (0.6–1.3 ppm, “aliphatic1”);
(2) aliphatic methyl and methylene near O and N (1.3–2.9 ppm, “aliphatic2”);
(3) O-alkyl, mainly from carbohydrates and lignin (2.9–4.1 ppm);
(4) alpha-proton of peptides (4.1–4.8 ppm);
(5) aromatic and phenolic (6.2–7.8 ppm); and
(6) amide, from proteins (7.8–8.4 ppm).
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Lynch2019}}
\code{\link{bins_Mitchell2018}} \code{\link{bins_Hertkorn2013}}
}
\keyword{datasets}
