% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-functions_graphs.R
\name{nmr_plot_spectra}
\alias{nmr_plot_spectra}
\title{Plot NMR spectra}
\usage{
nmr_plot_spectra(
  dat,
  binset,
  label_position = 100,
  mapping = aes(x = ppm, y = intensity),
  stagger = 10
)
}
\arguments{
\item{dat}{Processed spectral data, output from (a) \code{\link{nmr_import_spectra}}
and \code{\link{nmr_assign_bins}}; or (b) \code{\link{nmr_import_peaks}}}

\item{binset}{A binset; e.g. \code{\link{bins_Clemente2012}},
\code{\link{bins_Hertkorn2013}}, etc., or a similarly-structured data frame}

\item{label_position}{y-axis position for bin labels}

\item{mapping}{An aesthetic mapping generated by \code{\link[ggplot2]{aes}}:
\code{aes(x = ..., y = ...)}}

\item{stagger}{How much to stagger the labels, numeric;
same units as \code{label_position}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot NMR spectra, with line-brackets denoting binned regions.
Uses spectra data processed in MestreNova or TopSpin.
}
\examples{
sdir <- system.file("extdata", "kfp_hysteresis", "spectra_mnova", package = "nmrrr")
spec <- nmr_import_spectra(path = sdir, method = "mnova")
library(ggplot2)
p_aes <- aes(x = ppm, y = intensity)
p <- nmr_plot_spectra(spec, bins_Clemente2012, 5, p_aes, stagger = 0.5)
p + ylim(0, 6)

}
\author{
Kaizad Patel
}
