% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mxm.R
\name{Mxm}
\alias{Mxm}
\title{Mxm}
\usage{
Mxm(d)
}
\arguments{
\item{d}{The dimension of the input vector on instantiation.}
}
\value{
The neural network that will ouput the maximum of a vector of
size \eqn{d} when activated with the ReLU function.

For a specific definition, see:
}
\description{
The function that returns the \eqn{\mathsf{Mxm}} neural networks.

\emph{Note:} Because of certain quirks of R we will have split
into five cases. We add an extra case for \eqn{d = 3}. Unlike the paper
we will simply reverse engineer the appropriate \emph{d}.
}
\examples{
Mxm(1) |> inst(ReLU, -5)
Mxm(3) |> inst(ReLU, c(4, 5, 1))
Mxm(5) |> inst(ReLU, c(5, 3, -1, 6, 6))

}
\references{
Lemma 4.2.4. Jentzen, A., Kuckuck, B., and von Wurstemberger, P. (2023).
Mathematical introduction to deep learning: Methods, implementations,
and theory. \url{https://arxiv.org/abs/2310.20360}
}
