% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rct}
\alias{rct}
\title{Reflexivity Contingency Table (RCT)}
\usage{
rct(x, lab, is.ipd = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSE}).}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns the \eqn{2 \times 2} RCT, see the description above for more detail.
}
\description{
Returns the RCT given the IPD matrix or data set \code{x}, the RCT is \eqn{2 \times 2} regardless of the 
number of classes in the data set.

RCT is constructed by categorizing the NN pairs according to pair type as self or mixed and whether
the pair is reflexive or non-reflexive. 
A base-NN pair is called a reflexive pair, if the elements of the pair are NN to each other;
a non-reflexive pair, if the elements of the pair are not NN to each other;
a self pair, if the elements of the pair are from the same class; a mixed pair, if the
elements of the pair are from different classes.
Row labels in the RCT are \code{"ref"} for reflexive and \code{"non-ref"} for non-reflexive and 
column labels are \code{"self"} and \code{"mixed"}.

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.

See also (\insertCite{ceyhan:NNreflexivity2017,ceyhan:NNreflex1D2018;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

rct(ipd,cls)
rct(Y,cls,is.ipd = FALSE)
rct(Y,cls,is.ipd = FALSE,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
rct(ipd,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

rct(ipd,cls)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{nnct}}, \code{\link{tct}} and \code{\link{scct}}
}
\author{
Elvan Ceyhan
}
