% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rnonRL}
\alias{rnonRL}
\title{Non-Random Labeling of a Given Set of Points}
\usage{
rnonRL(
  dat,
  par.vec,
  type,
  rand.init = TRUE,
  poisson = FALSE,
  init.from.cases = TRUE
)
}
\arguments{
\item{dat}{A set of points the non-RL procedure is applied to obtain cases and controls randomly in the 
\code{type=type} fashion (see the description).}

\item{par.vec}{The parameter vector. It is \code{c(prop,k,rho)} for type I, \code{c(k,rho,pow,init.prop,ult.prop)}
for type II, \code{c(prop,rho,pow)} for type III, and \code{c(init.prop,ult.prop,s1,s2,rho)} for type IV non-RL patterns.
The parameters must be entered in this order in \code{par.vec} as a vector.
See the respective functions for more detail on the parameters.}

\item{type}{The type of the non-RL pattern. Takes on values \code{"I"}-\code{"IV"} for types I-IV non-RL
patterns (see the description above).}

\item{rand.init}{A logical argument (default is \code{TRUE}) to determine the choice of the initial case(s)
in the data set, \code{dat} for types II-IV non-RL pattern. If \code{rand.init=TRUE} then the initial case(s) is (are)
selected randomly from the data points, and if \code{rand.init=FALSE}, the first one is labeled as a case for type III
and the first \code{init.prop*n} entries in the data set, \code{dat}, are labeled as the cases types II and IV.}

\item{poisson}{A logical argument (default is \code{FALSE}) to determine whether the number of cases is random or fixed.
In types II and IV initial and ultimate number of cases, \eqn{k_0} and \eqn{n_1}, will be random if \code{poisson=TRUE} and fixed
otherwise. In types I and III the number of cases, \eqn{n_1}, will be random if poisson=TRUEURE and fixed otherwise.
See the description.}

\item{init.from.cases}{A logical argument (default is \code{TRUE}) to determine whether the initial cases at each
round will be take from cases or controls in type I non-RL pattern. 
The initial cases are taken from cases if \code{init.from.cases=TRUE}, and from controls otherwise.
See the function \code{\link{rnonRLI}}.}
}
\value{
A \code{list} with the elements
\item{pat.type}{\code{="cc"} for the case-control patterns for RL or non-RL of the given data points, \code{dat}}
\item{type}{The type of the point pattern}
\item{parameters}{\code{par.vec}, the parameters required for each type of non-RL pattern. See the description
in the parameter list.}
\item{lab}{The labels of the points as 1 for cases and 0 for controls after the nonRL procedure is
applied to the data set, \code{dat}. Cases are denoted as red dots and controls as black circles in the plot.}
\item{init.cases}{The initial cases in the data set, \code{dat}. Marked with red crosses in the plot of the points.}
\item{cont.cases}{The contagious cases in the data set, \code{dat} in type II non-RL pattern.
Denoted as blue points in the plot of the points.}
\item{gen.points,ref.points}{Both are \code{NULL} for this function, as initial set of points, \code{dat}, are provided
for all of the non-RL procedures.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of cases and controls.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Given the set of \eqn{n} points, \code{dat}, in a region, this function assigns some of them as cases,
and the rest as controls in a non-RL \code{type=type} fashion. 

Type I nonRL pattern assigns \eqn{n_1=}\code{round(n*prop,0)} of the data points as cases,
and the rest as controls with first selecting a point, \eqn{Z_i}, as a case and assigning the
label case to the remaining points with infection probabilities \code{prob=c(prop+((1-prop)*rho)/(1:k))} where \code{rho} is a
parameter adjusting the NN dependence of infection probabilities.

Type II nonRL pattern assigns \eqn{n_1=}\code{round(n*ult.prop,0)} of them as cases,
and the rest as controls with first selecting \eqn{k_0=}\code{round(n*init.prop,0)} as cases initially, then selecting
a contagious case and then assigning the label case to the remaining points with infection probabilities 
inversely proportional to their position in the \code{k}NNs.

Type III nonRL pattern assigns \eqn{n_1=}\code{round(n*prop,0)} of them as cases,
and the rest as controls with first selecting a point, \eqn{Z_i}, as a case and assigning the
label case to the remaining points with infection probabilities \eqn{prob=rho (1-d_{ij}/d_{\max})^{pow}} where \eqn{d_{ij}} is the
distance from \eqn{Z_j} to \eqn{Z_i} for \eqn{j \ne i}, \eqn{d_{\max}} is the maximum of  \eqn{d_{ij}}  values, \code{rho} is a scaling parameter for
the infection probabilities and \code{pow} is a parameter in the power adjusting the distance dependence.

Type IV nonRL pattern assigns \eqn{n_1=}\code{round(n*ult.prop,0)} of them as cases,
and the rest as controls with first selecting \eqn{k_0=}\code{round(n*init.prop,0)} as cases initially and assigning the
label case to the remaining points with infection probabilities equal to the scaled bivariate normal density values
at those points.

The number of cases in Types I and III will be \eqn{n_1} on the average if the argument \code{poisson=TRUE}
(i.e., \eqn{n_1=}\code{rpois(1,round(n*prop,0))} ), otherwise \eqn{n_1=}\code{round(n*prop,0)}.
The initial and ultimate number of cases in Types II and IV will be \eqn{k_0} and \eqn{n_1} on the average if the argument
\code{poisson=TRUE} (i.e., \eqn{k_0=}\code{rpois(1,round(n*init.prop,0)}) and \eqn{n_1=}\code{rpois(1,round(n*ult.prop,0))}), otherwise
they will be exactly equal to \eqn{n_1=}\code{round(n*ult.prop,0)} and \eqn{k_0=}\code{round(n*init.prop,0)}.

At each type, we stop when we first exceed \eqn{n_1} cases. That is, the procedure ends when number of cases \eqn{n_c}
exceed \eqn{n_1}, and \eqn{n_c-n_1} of the cases (other than the initial case(s)) are randomly selected and relabeled as
controls, i.e., 0s, so that the number of cases is exactly \eqn{n_1}.

In the output cases are labeled as 1 and controls as 0, and initial contagious case is marked with a red cross
in the plot of the pattern.

See \insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat} and the functions \code{\link{rnonRLI}},
\code{\link{rnonRLII}}, \code{\link{rnonRLIII}}, and \code{\link{rnonRLIV}} for more detail on each type of
non-RL pattern.

Although the non-RL pattern is described for the case-control setting, it can be adapted for any two-class
setting when it is appropriate to treat one of the classes as cases or one of the classes behave like cases
and other class as controls.

The parameters of the non-RL patterns are specified in the argument \code{par.vec}, and the logical arguments \code{rand.init}
and poisson pass on to the types where required. \code{rand.init} is not used in type I but used in all other types,
poisson is used in all types, and init.from.cases is used in type I non-RL only.
}
\examples{
#data generation
n<-40;  #try also n<-20; n<-100;
dat<-cbind(runif(n,0,1),runif(n,0,1))

#Type I non-RL pattern
#c(prop,k,rho) for type I
prop<-.5; knn<-3; rho<- .3
prv<-c(prop,knn,rho)

Xdat<-rnonRL(dat,type="I",prv) #labeled data 
# or try Xdat<-rnonRL(dat,type="I",prv) for type I non-RL
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#Type II non-RL pattern
#c(k,rho,pow,init.prop,ult.prop) for type II
rho<-.8; pow<-2; knn<-5; ip<-.3; up<-.5
prv<-c(knn,rho,pow,ip,up)

Xdat<-rnonRL(dat,type="II",prv) #labeled data 
# or try Xdat<-rnonRL(dat,type="I",prv) for type I non-RL
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#Type III non-RL pattern
#c(prop,rho,pow) for type III
prop<- .5; rho<-.8; pow<-2
prv<-c(prop,rho,pow)

Xdat<-rnonRL(dat,type="III",prv) #labeled data 
# or try Xdat<-rnonRL(dat,type="I",prv) for type I non-RL
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#Type IV non-RL pattern
#c(init.prop,ult.prop,s1,s2,rho) for type IV
ult<-.5; int<- .1; s1<-s2<-.4; rho<- .1
prv<-c(int,ult,s1,s2,rho)

Xdat<-rnonRL(dat,type="IV",prv) #labeled data 
# or try Xdat<-rnonRL(dat,type="I",prv) for type I non-RL
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat) 
  
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rnonRLI}}, \code{\link{rnonRLII}}, \code{\link{rnonRLIII}}, and \code{\link{rnonRLIV}}
}
\author{
Elvan Ceyhan
}
