% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNTCalculation.R
\name{KM2NNT}
\alias{KM2NNT}
\title{Calculate the NNT based on the Kaplan-Meier estimated
survival rates between the treatment and control groups}
\usage{
KM2NNT(time, status, arm, tau = NULL, confint = 0.95, digits = 3)
}
\arguments{
\item{time}{The time to event or censor.}

\item{status}{The indicator of the event or censor at the end of the follow-up.}

\item{arm}{The variable indicates the treatment (arm = 1) and control (arm = 0) groups.}

\item{tau}{The chosen time point of clinical interest.}

\item{confint}{The percentile of confidence interval. The default value is
\code{confint = 0.95}.}

\item{digits}{The decimal of the results. The default value is \code{digits = 3}.}
}
\value{
A matrix contains the KM-NNT and its confidence interval.
}
\description{
For survival endpoints, the NNT-KM is computed as the reciprocal of
 the absolute risk reduction (ARR),
 which is the difference in Kaplan-Meier estimated survival rates or
 the difference in cumulative incidences at a time point of clinical
 interest between the treatment and control groups.
}
\examples{
library(survival)
dat <- pbc[!is.na(pbc$trt),]
time <- dat$time/365.25
status <- (dat$status == 2) + 0
arm <- (dat$trt == 2) + 0
KM2NNT(time, status, arm, tau = NULL, confint = 0.95, digits = 3)

}
\references{
1. Altman DG, Andersen PK: Calculating the number needed to treat for trials
where the outcome is time to an event. BMJ 319:1492-5, 1999

2. Altman DG: Confidence intervals for the number needed to treat. BMJ
317:1309-12, 1998
}
