% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testProcedure.R
\name{graphInference}
\alias{graphInference}
\title{new graph inference procedure}
\usage{
graphInference(
  dataMatrix,
  nodeClustering,
  theta,
  alpha = 0.05,
  modelFamily = "Gauss"
)
}
\arguments{
\item{dataMatrix}{observed adjacency matrix, nxn matrix}

\item{nodeClustering}{n-vector of hard node Clustering}

\item{theta}{parameter of the noisy stochastic block model}

\item{alpha}{confidence level}

\item{modelFamily}{probability distribution for the edges. Possible values:
\code{Gauss} and \code{Gamma}}
}
\value{
a list with:
 \describe{
    \item{\code{A}}{resulting binary adjacency matrix}
    \item{\code{qvalues}}{vector with conditional q-values in the noisy stochastic block model}
 }
}
\description{
new graph inference procedure
}
\details{
graph inference procedure based on conditional q-values in the noisy stochastic block model. It works in the
Gaussian model, and also in the Gamma model, but only if the shape parameters of the
Gamma distributions under the null and the alternatives are identical (e.g. when all distributions
are exponentials).
}
\examples{
set.seed(1)
theta <- list(pi=c(.5,.5), w=c(.8,.1,.2), nu0=c(0,1), nu=matrix(c(-1,5,10, 1,1,1), ncol=2))
obs <- rnsbm(n=30, theta)
# res_gauss <- fitNSBM(obs$dataMatrix, nbCores=1)
resGraph <- graphInference(obs$dataMatrix, res_gauss[[2]]$clustering, theta, alpha=0.05)
sum((resGraph$A))/2 # nb of derived edges
sum(obs$latentAdj)/2 # correct nb of edges
}
