% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{PagesEndpoint}
\alias{PagesEndpoint}
\title{R6 Class for Pages Endpoint}
\value{
A list containing the parsed API response.
}
\description{
Handle all pages operations in the Notion API

\strong{Note:} Access this endpoint through the client instance, e.g., \code{notion$pages}. Not to be instantiated directly.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{notionapi::vcr_example_start("notion-pages-create")}
notion <- notion_client()

# ----- create a page
notion$pages$create(
  list(page_id = "22f33ea0c1e480b99c77d1ab72aedff9"),
  list(
    title = list(list(
      text = list(
        content = "Test Page for notionapi"
      )
    ))
  )
)
\dontshow{notionapi::vcr_example_end()}

# ----- retrieve a page
\dontshow{notionapi::vcr_example_start("notion-pages-retrieve")}
notion$pages$retrieve("23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba")
\dontshow{notionapi::vcr_example_end()}
\dontshow{\}) # examplesIf}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{properties}}{Pages properties endpoint}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PagesEndpoint-new}{\code{PagesEndpoint$new()}}
\item \href{#method-PagesEndpoint-create}{\code{PagesEndpoint$create()}}
\item \href{#method-PagesEndpoint-retrieve}{\code{PagesEndpoint$retrieve()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PagesEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-PagesEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Initialise pages endpoint.
Not to be called directly, e.g., use \code{notion$pages} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PagesEndpoint$new(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Notion Client instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PagesEndpoint-create"></a>}}
\if{latex}{\out{\hypertarget{method-PagesEndpoint-create}{}}}
\subsection{Method \code{create()}}{
Create a page
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PagesEndpoint$create(
  parent,
  properties,
  children = NULL,
  icon = NULL,
  cover = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{Named list (JSON object) (required). The parent page or database where the new page is inserted.}

\item{\code{properties}}{Named list (JSON object) (required). Key-value pairs representing the properties of the page.}

\item{\code{children}}{List of lists (JSON array). Block objects to append as children to the page.}

\item{\code{icon}}{Named list (JSON object). An icon for the page.}

\item{\code{cover}}{Named list (JSON object). A cover image for the page.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/post-page}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PagesEndpoint-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-PagesEndpoint-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve page properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PagesEndpoint$retrieve(page_id, filter_properties = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{page_id}}{Character (required.). The ID for a Notion page.}

\item{\code{filter_properties}}{Character. Page property value IDs to include in the response schema.
If NULL, all properties are returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/retrieve-a-page}{Endpoint documentation}
}

}
}
