% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nparms.R
\name{nparms}
\alias{nparms}
\title{Nonparametric Test For Multivariate Data With Two-Way Layout Factorial Design - Small Samples}
\usage{
nparms(formula,data)
}
\arguments{
\item{formula}{an object of class "formula" with two explanatory variables (factors), see examples.}

\item{data}{an object of class "data.frame" containing the variables in the formula}
}
\value{
Returns a list of data frames providing the values of the test statistics, p-values, degrees of freedom, factor levels,
and groupsize per factor level combination.
}
\description{
Analysis of multivariate data with two-way completely randomized
factorial design - version for small samples. The analysis is based on fully nonparametric, rank-based methods and
uses a N(0,1)-approximation for test statistics based on 'Dempster's ANOVA', 'Wilk's Lambda', 'Lawley-Hotelling' and
'Bartlett-Nanda-Pillai' criteria. This approximation is established by the asymptotic distribution
of these four statistics under true null-hypothesis if one of the explanatory factors has a large number
of levels. The multivariate response is allowed to be ordinal, quantitative, binary or a mixture
of the different variable types. The test statistics are constructed using nonparametric relative effect estimators.
}
\details{
This method is only implemented for complete data sets without missing values. The data is analysed for main effects
and interaction effect of the explanatory factors. In each case the null hypothesis "no effect" is testet. The explanatory factor 
that has the higher number of levels is automatically designated as factor "A". The covariance matrix
estimation requires at least 4 observations (observation vectors) per factor level combination. As the estimation is very time-consuming
for large groups it is performed wih a random selection of observations when a group exceeds a size of 6 observation vectors.
}
\examples{
data(pseudostudy2)
nparms(resp1|resp2|resp3~treatment*age, pseudostudy2)
}
\references{
Kiefel M., Freidl J. (2024)
Nonparametric Analysis of Multivariate Data in Factorial Designs with Nondetects: A Case Study with Microbiome Data
In: Journal of Agricultural, Biological, and Environmental Statistics
https://doi.org/10.1007/s13253-024-00671-5.

Kiefel M., Bathke A.C. (2022)
Fully Nonparametric Methods for Multivariate Data in Factorial Designs. Asymptotics, Finite Sample Approximations, and Implementation in R
In: Open Statistics, vol. 3, 2022, p. 74
https://doi.org/10.1515/stat-2022-0112

Kiefel M., Bathke A.C. (2020)
Rank-Based Analysis of Multivariate Data in Factorial Designs and Its Implementation in R
In: Nonparametric Statistics (285-294)
Springer Proceedings in Mathematics & Statistics
Springer International Publishing, Cham

Bathke A.C., Harrar S.W. (2016)
Rank-Based Inference for Multivariate Data in Factorial Designs.
In: Liu R., McKean J. (eds) Robust Rank-Based and Nonparametric Methods.
Springer Proceedings in Mathematics & Statistics, vol 168. Springer, Cham

Harrar S.W., Bathke A.C. (2012)
A modified two-factor multivariate analysis of variance:
asymptotics and small sample approximations (and erratum).
In: Annals of the Institute of Statistical Mathematics, 64(1&5):135-165&1087, 2012.

Brunner E., Dette H., Munk A. (1997)
Box-Type Approximations in Nonparametric Factorial Designs
In: Journal of the American Statistical Association, 92(440):1494-1502
}
