% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npde.R
\docType{package}
\name{npde-package}
\alias{npde-package}
\title{Normalised prediction distribution errors for nonlinear mixed-effect models}
\description{
Routines to compute normalised prediction distribution errors, a metric
designed to evaluate non-linear mixed effect models such as those used in
pharmacokinetics and pharmacodynamics
}
\examples{
data(theopp)
data(simtheopp)

# Calling autonpde with dataframes

x<-autonpde(theopp,simtheopp,ix="Time",iy="Conc",iid="ID",boolsave=FALSE)
print(x)

}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.
Mentre. Metrics for external model evaluation with an application to the
population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research},
23:2036--49, 2006.

PDF documentation for npde 3.0: \url{https://github.com/ecomets/npde30/blob/main/userguide_npde_3.0.pdf}
}
\author{
Emmanuelle Comets, Karl Brendel, Thi Huyen Tram Nguyen, France Mentre

Maintainer: Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{models}
