% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demand_sim.R
\name{demand_sim}
\alias{demand_sim}
\title{Simulate the demand for new products}
\usage{
demand_sim(
  products_number,
  periods_number,
  shape_number,
  shape_type = "random",
  level_number,
  level_range = 1000:10000,
  noise_cv = 0.05
)
}
\arguments{
\item{products_number}{Number of products}

\item{periods_number}{Number of periods of the introduction and growth phases}

\item{shape_number}{Number of generic shapes}

\item{shape_type}{Type of shape to generate. It can take the values: "triangle",
"trapezoid", "bass", "random" and "intro & growth".
  The type "random" picks one of the types "triangle",
"trapezoid", "bass" randomly for each product.
The type "intro & growth" is used for the shapes of the introduction
and growth phases.}

\item{level_number}{Number of generic levels}

\item{level_range}{Range of values from which the level is sampled}

\item{noise_cv}{The coefficient of variation of the noise added to the simulated sales}
}
\value{
A date frame that contains the following columns: product_id, shape and assigned_shape,
         level and assigned_level, demand_wn (demand without noise, not rounded),
         noise and demand. demand is the rounded value of the Max
         between (demand_wn+noise) and 0
}
\description{
Simulate the demand for new products over their life cycle by
specifying their shape type.
}
\examples{
demand_sim(products_number=100,periods_number=20,shape_number=5, level_number=20)

demand_sim(products_number=100,periods_number=20,shape_number=5, shape_type="bass", level_number=20,
level_range=1000:10000,noise_cv=0.05)
}
