% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_at_risk.R
\name{find_at_risk}
\alias{find_at_risk}
\title{Calculate at-risk table}
\usage{
find_at_risk(formula, data, include_cens = TRUE, timefix = TRUE)
}
\arguments{
\item{formula}{Formula object. The response (on the left of the \code{~} operator) must be a survival object as returned by the \code{Surv} function.
The terms (on the right of the \code{~} operator) must include the treatment arm indicator, and additionally can include strata using the \code{strata} function.}

\item{data}{Data frame containing time-to-event data.}

\item{include_cens}{Boolean indicating whether to include values corresponding to censoring times}

\item{timefix}{Deal with floating point issues (as in the survival package). Default is TRUE. May need to set FALSE for simulated data.}
}
\value{
Data frame

Returns a data frame with the following columns:
\itemize{
\item time \code{t_j}
\item number of events in each of the treatments at \code{t_j}
\item combined number of events in both treatments at event time \code{t_j}
\item number of individuals at risk in each of the treatment groups just before time \code{t_j}
\item combined number of individuals at risk in both treatment groups just before time \code{t_j}
}
}
\description{
This function calculates the number of individuals at risk and number of events at each distinct event time
(and censoring time if \code{include_cens==TRUE}).
}
\examples{
library(nphRCT)
set.seed(1)
sim_data <- sim_events_delay(
  event_model=list(
    duration_c = 36,
    duration_e = c(6,30),
    lambda_c = log(2)/9,
    lambda_e = c(log(2)/9,log(2)/18)
  ),
  recruitment_model=list(
    rec_model="power",
    rec_period = 12,
    rec_power = 1
  ),
  n_c=5,
  n_e=5,
  max_cal_t = 36
)
#with censoring times included
find_at_risk(formula=survival::Surv(event_time,event_status)~group,
  data=sim_data,
  include_cens=TRUE)
#with censoring times excluded
find_at_risk(formula=survival::Surv(event_time,event_status)~group,
  data=sim_data,
  include_cens=FALSE)
}
