% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_group-by.R
\name{nest_group_by}
\alias{nest_group_by}
\alias{nest_ungroup}
\title{Group nested data frames by one or more variables}
\usage{
nest_group_by(.data, .nest_data, ..., .add = FALSE, .drop = TRUE)

nest_ungroup(.data, .nest_data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{In \code{nest_group_by()}, variables or computations to group by.
Computations are always done on the ungrouped data frames. To perform
computations on the grouped data, you need to use a separate \code{mutate()}
step after the \code{group_by()}.
In \code{nest_ungroup()}, variables to remove from the grouping.}

\item{.add}{When \code{FALSE} (the default), \code{nest_group_by()} will override the
existing groups. To add to the existing groups, use \code{.add = TRUE}.}

\item{.drop}{Drop groups formed by factor levels that don't appear in the
data? The default is \code{TRUE} except when \code{.nest_data} has been previously
grouped with \code{.drop = FALSE}. See \code{\link[dplyr:group_by_drop_default]{dplyr::group_by_drop_default()}} for
details.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will be returned as a grouped data frame with class \code{grouped_df}, unless the
combination of \code{...} and \code{.add} yields an empty set of grouping columns, in
which case a tibble will be returned.
}
\description{
\code{nest_group_by()} takes a set of nested tbls and converts it to a set of
nested grouped tbls where operations are performed "by group".
\code{nest_ungroup()} removes grouping.
}
\details{
\code{nest_group_by()} and \code{nest_ungroup()} are largely wrappers for
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:group_by]{dplyr::ungroup()}} and maintain the functionality of
\code{group_by()} and \code{ungroup()} within each nested data frame. For more
information on \code{group_by()} or \code{ungroup()}, please refer to the documentation
in \href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

# grouping doesn't change .nest_data, just .nest_data class:
gm_nest_grouped <-
  gm_nest \%>\%
  nest_group_by(country_data, year)

gm_nest_grouped

# It changes how it acts with other nplyr verbs:
gm_nest_grouped \%>\%
  nest_summarise(
    country_data,
    lifeExp = mean(lifeExp),
    pop = mean(pop),
    gdpPercap = mean(gdpPercap)
  )

# ungrouping removes variable groups:
gm_nest_grouped \%>\% nest_ungroup(country_data)
}
\concept{grouping functions}
