% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{NW.WtKernel}
\alias{NW.WtKernel}
\title{Title  Nadaraya-Watson Kernel estimator at x0}
\usage{
NW.WtKernel(Xvec, Yvec, X0, Kernel = "Ep", Bndwdth, Wt = 1)
}
\arguments{
\item{Xvec, Yvec}{numeric vectors of data values, Xvec and Yvec must have the same length.}

\item{X0}{a given value}

\item{Kernel}{a character string indicating which kernel function is to be used. Use of "Ep", "Bw", or "Nm" for Epanechnikov, Biweight or Normal kernel function.}

\item{Bndwdth}{a bandwidth of the kernel}

\item{Wt}{a weight vector or a constant. For longitudinal data, Wt=1/N corresponds to measurement uniform weight and Wt=1/(nni) corresponds subject uniform weight.}
}
\value{
The kernel estimator at x0
}
\description{
Title  Nadaraya-Watson Kernel estimator at x0
}
\examples{
X <- seq(0, 1, len=100)
Y <- (X- 0.5)^3 - 2*(X-0.5)^2+ rnorm(100, 0, 0.1)
NW.WtKernel(X, Y,  X0=0.5, Kernel="Ep", Bndwdth=0.3, Wt=1 )
NW.WtKernel(X, Y,  X0=0.5, Kernel="Nm", Bndwdth=0.3, Wt=1 )
}
\references{
{ \enumerate{
 \item Fan, J. and Gijbels, I. Local Polynomial Modeling and Its Applications.
     Chapman & Hall, London, United Kingdom, 1996.
 \item  Wu, C.O. and Tian, X.   Nonparametric Models for Longitudinal Data. Chapman & Hall/CRC. To appear.}}
}
