% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{kernel.fit}
\alias{kernel.fit}
\title{Nadaraya-Watson Kernel estimator}
\usage{
kernel.fit(Xint, Xvec, Yvec, bw, Kernel = "Ep", Wt = 1)
}
\arguments{
\item{Xint}{a vector of x interval to generate the local linear fit}

\item{Xvec, Yvec}{numeric vectors of data values, Xvec and Yvec must have the same length.}

\item{bw}{a bandwidth of the kernel}

\item{Kernel}{a character string indicating which kernel function is to be used. Use of "Ep", "Bw", or "Nm" for Epanechnikov, Biweight or Normal kernel function.}

\item{Wt}{a weight vector}
}
\description{
Nadaraya-Watson Kernel estimator
}
\examples{
X <- seq(0, 1, len=100)
Y <- (X- 0.5)^3 - 2*(X-0.5)^2+ rnorm(100, 0, 0.1)
kernel.fit(seq(0,1,0.1), X, Y, Kernel="Ep", bw=0.1, Wt=1   )
}
\references{
{ \enumerate{
 \item Fan, J. and Gijbels, I. Local Polynomial Modeling and Its Applications.
     Chapman & Hall, London, United Kingdom, 1996.
 \item  Wu, C.O. and Tian, X.   Nonparametric Models for Longitudinal Data. Chapman & Hall/CRC. To appear.}}
}
