% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macor.R
\name{macor}
\alias{macor}
\title{Multi-Domain Additional Explained Correlation}
\usage{
macor(x, coef, center = TRUE, scale_ = FALSE)
}
\arguments{
\item{x}{a list of numeric matrices which contain the data from the different
domains}

\item{coef}{a list of matrices containing the canonical vectors related to
each data domain. Each matrix contains the respective canonical vectors as
its columns.}

\item{center}{a list of logical values indicating whether the empirical mean
of (each column of) the corresponding data matrix should be subtracted.
Alternatively, a list of vectors can be supplied, where each vector
specifies the mean to be subtracted from the corresponding data matrix.
Each list element is passed to \code{\link{scale}}.}

\item{scale_}{a list of logical values indicating whether the columns of the
corresponding data matrix should be scaled to have unit variance before the
analysis takes place. The default is \code{FALSE} for consistency with
\code{acor}. Alternatively, a list of vectors can be supplied, where each
vector specifies the standard deviations used to rescale the columns of the
corresponding data matrix. Each list element is passed to
\code{\link{scale}}.}
}
\value{
A list of class \code{mcancor} with the
  following elements: \item{cor}{a multi-dimensional array containing the
  additional correlations explained by each pair of canonical variables. The
  first two dimensions correspond to the domains, and the third dimension
  corresponds to the different canonical variables per domain.}
  \item{coef}{copied from the input arguments} \item{center}{the list of
  empirical means used to center the data matrices} \item{scale}{the list of
  empirical standard deviations used to scale the data matrices}\item{xp}{the
  list of deflated data matrices corresponding to \code{x}}
}
\description{
\code{macor} generalizes \code{\link{acor}} to the case of more than two data
domains.
}
\examples{
x <- matrix(runif(10*5), 10)
y <- matrix(runif(10*5), 10)
z <- matrix(runif(10*5), 10)

xcoef <- matrix(rnorm(2*5), 5)
ycoef <- matrix(rnorm(2*5), 5)
zcoef <- matrix(rnorm(2*5), 5)

# Explained multi-domain correlation
macor(list(x, y, z), list(xcoef, ycoef, zcoef))$cor
}
