% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_rects_advanced.R
\name{draw_rects_advanced}
\alias{draw_rects_advanced}
\title{Plot NSP intervals of significance at appropriate places along the graph of data}
\usage{
draw_rects_advanced(
  y,
  nsp.obj,
  half.height = NULL,
  show.middles = TRUE,
  col.middles = "blue",
  lwd = 3,
  density = 10,
  col.rects = "red",
  x.axis.start = 1
)
}
\arguments{
\item{y}{The data.}

\item{nsp.obj}{Object returned by one of the \code{nsp*} functions with \code{y} on input.}

\item{half.height}{Half-height of each rectangle; if \code{NULL} then set to twice the estimated standard deviation of the data.}

\item{show.middles}{Whether to display lines corresponding to the midpoints of the rectanlges (rough change-point location estimates).}

\item{col.middles}{Colour of the midpoint lines.}

\item{lwd}{Line width for the midpoint lines.}

\item{density}{Density of the shading.}

\item{col.rects}{Colour of the shading.}

\item{x.axis.start}{Time index the x axis starts from. The NSP intervals of significance get shifted by \code{x.axis.start-1} prior to plotting.}
}
\value{
The function does not return a value.
}
\description{
This function plots the intervals of significance returned by one of the \code{nsp*} functions, at appropriate places along the graph of data.
It shows them as shaded rectangular areas (hence the name of the function) "attached" to the graph of the data. Note: the data sequence \code{y}
needs to have been plotted beforehand.
}
\details{
The NSP algorithm is described in P. Fryzlewicz (2021) "Narrowest Significance Pursuit: inference for multiple change-points in linear
models", preprint.
}
\examples{
set.seed(1)
f <- c(rep(0, 100), 1:100, rep(101, 100))
x.f <- f + 15 * stats::rnorm(300)
x.f.n <- nsp_poly(x.f, 100, "sim", deg=1)
stats::ts.plot(x.f)
draw_rects_advanced(x.f, x.f.n, density = 3)
}
\seealso{
\code{\link{draw_rects}}, \code{\link{nsp}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
