% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresh_kab.R
\name{thresh_kab}
\alias{thresh_kab}
\title{Compute the theoretical threshold for the multiscale sup-norm if the underlying distribution is standard normal}
\usage{
thresh_kab(n, alpha = 0.1, method = "asymp")
}
\arguments{
\item{n}{The sample size.}

\item{alpha}{The significance level.}

\item{method}{"asymp" for the asymptotic method; "bound" for the Bonferroni method.}
}
\value{
The desired threshold.
}
\description{
This function computes the theoretical threshold, corresponding to the given significance level \code{alpha}, for the multiscale sup-norm
if the underlying distribution is standard normal.
}
\details{
For the underlying theory, see Z. Kabluchko (2007) Extreme-value analysis of standardized Gaussian increments. Unpublished.
}
\examples{
set.seed(1)
f <- c(1:100, 100:1, 1:100)
y <- f + stats::rnorm(300) * 15
x <- matrix(0, 300, 2)
x[,1] <- 1
x[,2] <- seq(from = 0, to = 1, length = 300)
nsp(y, x, 100, 15 * thresh_kab(300, .1))
}
\seealso{
\code{\link{cov_dep_multi_norm}}, \code{\link{cov_dep_multi_norm_poly}}, \code{\link{sim_max_holder}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
