% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantize.R
\name{quantize_prep}
\alias{quantize_prep}
\title{Prepare stratified null model overhead for quantize()}
\usage{
quantize_prep(
  x,
  method = nullcat_methods(),
  fixed = c("cell", "stratum", "row", "col"),
  breaks = NULL,
  n_strata = 5,
  transform = identity,
  offset = 0,
  zero_stratum = FALSE,
  n_iter = 1000
)
}
\arguments{
\item{x}{Community matrix with sites in rows, species in columns, and
nonnegative quantitative values in cells.
This is the dataset for which stratification and null model overhead
should be prepared.}

\item{method}{Character string specifying the null model algorithm.
The default \code{"curvecat"} uses the categorical curveball algorithm.
See \code{\link[=nullcat]{nullcat()}} for alternative options.}

\item{fixed}{Character string specifying the level at which quantitative
values are held fixed during randomization. One of:
\itemize{
\item \code{"cell"} (the default; only available when \code{method = "curvecat"}):
values remain attached to their original cells and move with them during
the categorical randomization. Row and column value
distributions are not preserved, but the mapping between each original
cell and its randomized destination is fixed.
\item \code{"stratum"}: values are shuffled globally within each stratum,
holding only the overall stratum-level value distribution fixed.
\item \code{"row"}: values are shuffled within strata separately for each
row, holding each row’s value multiset fixed. Not compatible with all
\code{method}s.
\item \code{"col"}: values are shuffled within strata separately for each
column, holding each column’s value multiset fixed.
}
Note that this interacts with \code{method}: different null models
fix different margins in the underlying binary representation.}

\item{breaks}{Numeric vector of stratum breakpoints.}

\item{n_strata}{Integer giving the number of strata to split the
data into. Must be 2 or greater. Larger values yield randomizations
with less mixing but higher fidelity to the original marginal
distributions. Default is \code{5}. Ignored unless \code{breaks = NULL}.}

\item{transform}{A function used to transform the values in
\code{x} before assigning them to \code{n_strata} equal-width
intervals. Examples include \code{sqrt}, \code{log},
\code{rank} (for equal-occupancy strata), etc.;
the default is \code{identity}. If \code{zero_stratum = TRUE}, the
transformation is only applied on nonzero values. The function should
pass NA values. This argument is ignored unless \code{breaks = NULL}.}

\item{offset}{Numeric value between -1 and 1 (default 0) indicating
how much to shift stratum breakpoints relative to the binwidth (applied
during quantization as: \code{breaks <- breaks + offset * bw}). To
assess sensitivity to stratum boundaries, run \code{quantize()} multiple
times with different offset values. Ignored unless \code{breaks = NULL}.}

\item{zero_stratum}{Logical indicating whether to segregate zeros into their
own stratum. If \code{FALSE} (the default), zeros will likely be combined
into a stratum that also includes small positive numbers. If \code{breaks} is
specified, zero simply gets added as an additional break; if not, one
of the \code{n_strata} will represent zeros and the others will be nonzero ranges.}

\item{n_iter}{Number of iterations. Default is 1000. Larger values yield
more thorough mixing. Ignored for non-sequential methods. Minimum
burn-in times can be estimated with \code{suggest_n_iter()}.}
}
\value{
A list with class \code{"quantize_prep"} (if you want to set it)
containing the components needed by \code{quantize()}:
\itemize{
\item \code{x}: original quantitative marix \code{x},
\item \code{strata}: integer matrix of the same dimension as \code{x},
giving the stratum index (\code{1:n_strata}) for each cell.
\item \code{pool}: data structure encoding the quantitative value pools
used during reassignment.
\item \code{method}: the null model method used (as in the \code{method} argument).
\item \code{n_strata}, \code{transform}, \code{offset}, \code{fixed}:
the stratification and reassignment settings used to construct
\code{strata} and \code{pool}.
\item \code{sim_args}: named list of arguments passed to \code{nullcat()}
(e.g. \code{n_iter}).
}

This object is intended to be passed unchanged to the \code{prep} argument of
\code{\link[=quantize]{quantize()}} or \code{\link[=quantize_batch]{quantize_batch()}}.
}
\description{
\code{quantize_prep()} precomputes all of the stratification and bookkeeping
needed by \code{\link[=quantize]{quantize()}} for a given quantitative community
matrix. This is useful when you want to generate many randomizations of the
same dataset: the expensive steps (strata assignment, value pools, and
arguments for the underlying null model) are computed once, and the resulting
object can be passed to \code{quantize(prep = ...)} for fast repeated draws.
}
\details{
Internally, \code{quantize_prep()}:
\itemize{
\item transforms and stratifies \code{x} into \code{n_strata} numeric
intervals (via \code{\link[=stratify]{stratify()}}),
\item constructs the appropriate value pools given \code{fixed}, and
\item assembles arguments for the underlying null model call to \code{\link[=nullcat]{nullcat()}}.
}
The returned object can be reused across calls to \code{\link[=quantize]{quantize()}},
\code{\link[=quantize_batch]{quantize_batch()}}, or other helpers that accept a \code{prep} argument.
}
\examples{
set.seed(1)
comm <- matrix(rexp(50 * 40), nrow = 50,
               dimnames = list(paste0("site", 1:50),
                               paste0("sp", 1:40)))

# prepare overhead for a curvecat-backed stratified null model
prep <- quantize_prep(comm, method = "curvecat",
                      n_strata = 5,
                      fixed = "row",
                      n_iter = 2000)

# fast repeated randomizations using the same prep
rand1 <- quantize(prep = prep)
rand2 <- quantize(prep = prep)

}
\seealso{
\code{\link[=quantize]{quantize()}}, \code{\link[=quantize_batch]{quantize_batch()}}
}
