% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_permutation_test.R
\name{plot_permutation_test}
\alias{plot_permutation_test}
\title{Create plot from \code{\link[=permutation_test]{permutation_test()}}.}
\usage{
plot_permutation_test(permutation_results, violin = FALSE)
}
\arguments{
\item{permutation_results}{object of class \code{permutation_results}.}

\item{violin}{Determines whether the variances explained are depicted by
distinct violin plots for each PC or by connected lines. the advantage of
lines is that they correctly indicate that values for each PC depend on one
another within a given permutation. That is, if an earlier PC soaks up a
lot of the variation in a data set, then there is less variation left to
explain by subsequent PCs. Default value is \code{FALSE}.}
}
\value{
\code{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} Plots results of a permutation test
carried out with the \code{\link[=permutation_test]{permutation_test()}} function. Now use either
\code{\link[=correlation_test]{correlation_test()}} or \code{\link[=pca_test]{pca_test()}} and the associated plotting functions.
}
\examples{
onze_perm <- permutation_test(
  onze_intercepts |> dplyr::select(-speaker),
  pc_n = 5,
  n = 10,
  scale = TRUE,
  cor.method = 'pearson'
 )
plot_permutation_test(onze_perm)
}
