% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_linelist.R
\name{augment_linelist}
\alias{augment_linelist}
\title{Append summaries of outbreaker results to a linelist}
\usage{
augment_linelist(
  out,
  linelist,
  params = c("t_inf", "kappa"),
  summary_fns = list(mean = function(x) mean(x, na.rm = TRUE), q25 = function(x)
    quantile(x, 0.25, na.rm = TRUE), q75 = function(x) quantile(x, 0.75, na.rm = TRUE))
)
}
\arguments{
\item{out}{An \code{outbreaker_chains} object containing posterior samples.}

\item{linelist}{A \code{data.frame} with an \code{id} column matching the IDs in \code{out}.}

\item{params}{Character vector of parameter prefixes to summarise (e.g. \code{"t_inf"}, \code{"kappa"}).}

\item{summary_fns}{A \strong{named} list of summary functions. Each function
takes a numeric vector and returns a single value.
Example:
\code{
  list(
    mean = function(x) mean(x, na.rm = TRUE),
    q25  = function(x) quantile(x, 0.25, na.rm = TRUE),
    q75  = function(x) quantile(x, 0.75, na.rm = TRUE)
  )
  }}
}
\value{
The input \code{linelist}, with new columns named
\code{<param>_<fn>} (e.g. \code{t_inf_mean}, \code{kappa_q25}).
}
\description{
For each case in \code{linelist}, appends summary statistics of selected parameters
from an \code{outbreaker_chains} object (e.g. infection times, number of generations).
}
\examples{
augmented_linelist <- augment_linelist(
  out, linelist,
  params = c("t_inf", "kappa"),
  summary_fns = list(
    median = function(x) median(x, na.rm = TRUE),
    q25 = function(x) quantile(x, 0.25, na.rm = TRUE),
    q75 = function(x) quantile(x, 0.75, na.rm = TRUE)
  )
)

}
