% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotPriceLevels}
\alias{plotPriceLevels}
\title{Plot order book price level heat map.}
\usage{
plotPriceLevels(depth, spread = NULL, trades = NULL, show.mp = T,
  show.all.depth = F, col.bias = 0.1, start.time = head(depth$timestamp,
  1), end.time = tail(depth$timestamp, 1), price.from = NULL,
  price.to = NULL, volume.from = NULL, volume.to = NULL,
  volume.scale = 1)
}
\arguments{
\item{depth}{The order book \code{\link{depth}}.}

\item{spread}{Spread to overlay obtained from \code{\link{getSpread}}.}

\item{trades}{\code{\link{trades}} data.}

\item{show.mp}{If True, spread will be summarised as midprice.}

\item{show.all.depth}{If True, show resting (and never hit) limit orders.}

\item{col.bias}{1 = uniform colour spectrum. 0.25 = bias toward 0.25
(more red less blue). <= 0 enables logarithmic scaling.}

\item{start.time}{Plot depth from this time onward.}

\item{end.time}{Plot depth up until this time.}

\item{price.from}{Plot depth with price levels >= this value.}

\item{price.to}{Plot depth with price levels <= this value.}

\item{volume.from}{Plot depth with volume >= this value relevant to
volume.scale}

\item{volume.to}{Plot depth with volume <= this value relevant to
volume scale.}

\item{volume.scale}{Volume scale factor.}
}
\description{
Produces a visualisation of the limit order book depth through time.
}
\details{
The available volume at each price level is colour coded according to the
range of volume at all price levels. The colour coding follows the visible
spectrum, such that larger amounts of volume appear "hotter" than smaller
amounts, where cold = blue, hot = red.

Since the distribution of limit order size exponentially decays, it can be
difficult to visually differentiate: most values will appear to be blue. The
function provides price, volume and a colour bias range to overcome this.
}
\examples{

# bid/ask spread.
spread <- with(lob.data, getSpread(depth.summary))

\dontrun{

# plot all depth levels, rescaling the volume by 10^-8.
# produce 2 plots side-by-side: second plot contains depth levels with > 50
# units of volume.
p1 <- with(lob.data, plotPriceLevels(depth, spread,
                                       col.bias=0.1,
                                       volume.scale=10^-8))
p2 <- with(lob.data, plotPriceLevels(depth, spread,
                                       col.bias=0.1,
                                       volume.scale=10^-8,
                                       volume.from=50))
library(grid)
pushViewport(viewport(layout=grid.layout(1, 2)))
print(p1, vp=viewport(layout.pos.row=1, layout.pos.col=1))
print(p2, vp=viewport(layout.pos.row=1, layout.pos.col=2))
}

# zoom into 1 hour of activity, show the spread and directional trades. 
with(lob.data, plotPriceLevels(depth, spread, trades,
   start.time=as.POSIXct("2015-05-01 03:25:00.000", tz="UTC"),
   end.time=as.POSIXct("2015-05-01 04:25:00.000", tz="UTC"),
   volume.scale=10^-8))

# zoom in to 15 minutes of activity, show the bid/ask midprice.
with(lob.data, plotPriceLevels(depth, spread,
   show.mp=FALSE,
   start.time=as.POSIXct("2015-05-01 03:30:00.000", tz="UTC"),
   end.time=as.POSIXct("2015-05-01 03:45:00.000", tz="UTC")))

}
\author{
phil
}

